%define kernel `uname -r`
%define version 2.1.0

Summary: "Vpb" - kernel driver and api for Voicetronix hardware
Name: Vpb
Version: %{version}
Release: 1
Group: Communication
Source: ftp://www.voxilla.org/pub/vpb/Vpb-driver-%{PACKAGE_VERSION}.tar.gz
Prefix: /usr
Copyright: GPL
BuildRoot: %{_tmppath}/vpb-root
Packager: David Sugar <dyfet@ostel.com>
Obsoletes: vpb2

%description
This library is the unified link libary and Linux kernel driver for
Voicetronix analog DSP telephony cards.  This package supports both the
ISA and PCI versions of the Voicetronix card and includes the advanced
DSP firmware for echo cancellation and channel joins.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -n Vpb-driver-%{version}

%build
make
(cd unittest ; make)

%install
mkdir -p $RPM_BUILD_ROOT/usr/include
mkdir -p $RPM_BUILD_ROOT/usr/lib
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/etc/vpb
mkdir -p $RPM_BUILD_ROOT/lib/modules/%{kernel}/misc
make root=$RPM_BUILD_ROOT install
install -s unittest/echo $RPM_BUILD_ROOT/usr/bin/vpb.echo
install -s unittest/loadrun $RPM_BUILD_ROOT/usr/bin/vpb.loadrun
install -s unittest/lowsam $RPM_BUILD_ROOT/usr/bin/vpb.lowsam
install -s unittest/mtisa $RPM_BUILD_ROOT/usr/bin/vpb.mtisa
install -s unittest/mtpci $RPM_BUILD_ROOT/usr/bin/vpb.mtpci
install -s unittest/playtone $RPM_BUILD_ROOT/usr/bin/vpb.playtone
install -s unittest/samcid $RPM_BUILD_ROOT/usr/bin/vpb.samcid
install -s unittest/tbecho $RPM_BUILD_ROOT/usr/bin/vpb.tbecho
install -s unittest/tbridge $RPM_BUILD_ROOT/usr/bin/vpb.tbridge
install -s unittest/tcomm $RPM_BUILD_ROOT/usr/bin/vpb.tcomm
install -s unittest/techophone $RPM_BUILD_ROOT/usr/bin/vpb.techophone
install -s unittest/tload $RPM_BUILD_ROOT/usr/bin/vpb.tload
install -s unittest/togbit $RPM_BUILD_ROOT/usr/bin/vpb.togbit
install -s unittest/tring $RPM_BUILD_ROOT/usr/bin/vpb.tring
install -s unittest/tsamecho $RPM_BUILD_ROOT/usr/bin/vpb.tsamecho
install -s unittest/tscr $RPM_BUILD_ROOT/usr/bin/vpb.tscr
install -s unittest/tseizure $RPM_BUILD_ROOT/usr/bin/vpb.tseizure
install -s unittest/tvpb8l $RPM_BUILD_ROOT/usr/bin/vpb.tvpb8l
install -s unittest/techophone2 $RPM_BUILD_ROOT/usr/bin/vpb.techophone2
install -s unittest/dsprun $RPM_BUILD_ROOT/usr/bin/vpb.dsprun
install -s unittest/dspreset $RPM_BUILD_ROOT/usr/bin/vpb.dspreset
install -s unittest/vpbmon $RPM_BUILD_ROOT/usr/bin/vpbmon
install -s unittest/measerl $RPM_BUILD_ROOT/usr/bin/vpb.measerl
install -s unittest/loopcid $RPM_BUILD_ROOT/usr/bin/vpb.loopcid
install -s unittest/playwav $RPM_BUILD_ROOT/usr/bin/vpb.playwav
install -s unittest/deccid $RPM_BUILD_ROOT/usr/bin/vpb.deccid
install -s unittest/offhook $RPM_BUILD_ROOT/usr/bin/vpb.offhook
install -s unittest/tvpb $RPM_BUILD_ROOT/usr/bin/tvpb

%files
%defattr(-,root,root,0755)
%doc README COPYING.TXT doc/*
%{prefix}/bin/*
%{prefix}/lib/*
%{prefix}/include/vpbapi.h
/etc/vpb/*.out
/lib/modules/*/misc/*

%clean
rm -rf $RPM_BUILD_ROOT

